package gov.va.med.mhv.portal.nsoc;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import com.bea.p13n.util.encoding.EncodingUtil;


public class XSSURLServletRequestWrapper extends HttpServletRequestWrapper{

	private List<String> urlParameterNames = new ArrayList<String>();

	public XSSURLServletRequestWrapper(HttpServletRequest request) {
		super(request);
		String qryString = request.getQueryString();
		if(qryString != null){
			String[] pairs = qryString.split("&");
			if(pairs != null && pairs.length > 0){
				for(String pair: pairs){
					urlParameterNames.add(pair.split("=")[0]);
				}
			}
		}
	}

	@Override
	public String[] getParameterValues(String parameter) {
		String[] values = super.getParameterValues(parameter);

	    if (values == null) {
	    	return null;
	    }

	    if (urlParameterNames == null){
    		return values;
    	}else{
		    boolean nameFound = false;
		    for(String name: urlParameterNames){
		    	if(name.equalsIgnoreCase(parameter)){
		    		nameFound = true;
		    		break;
		    	}
		    }
		    if(nameFound){
			    int count = values.length;
			    String[] encodedValues = new String[count];
			    for (int i = 0; i < count; i++) {
			    	encodedValues[i] = EncodingUtil.encodeXSS(values[i]);
			    }
				return encodedValues;
		    }
    	}
	    return values;
	}

	@Override
	public String getParameter(String parameter) {
		String value = super.getParameter(parameter);
		boolean nameFound = false;
	    for(String name: urlParameterNames){
	    	if(name.equalsIgnoreCase(parameter)){
	    		nameFound = true;
	    		break;
	    	}
	    }
	    if(nameFound){
	    	value = EncodingUtil.encodeXSS(value);
	    }
	    return value;
	}

	@Override
	public String getHeader(String name) {
		String value = super.getHeader(name);
		return EncodingUtil.encodeXSS(value);
	}

}
